define(['angular', 'app', 'text!../resources.json'], function (angular, app, resourceDirectory) {
	"use strict";

	app.config(function ($controllerProvider, $provide, $httpProvider, BaseFHIRConfigProvider) {
		$httpProvider.defaults.useXDomain = true;
		delete $httpProvider.defaults.headers.common['X-Requested-With'];
		$httpProvider.interceptors.push('httpInterceptor');
		$httpProvider.interceptors.push('busyHttpInterceptor');

		var resources = JSON.parse(resourceDirectory).link,
			directory = {};
		resources.forEach(function (link){
			directory[link['title']] = link.href;
		});
		BaseFHIRConfigProvider.setUrl(directory['pgd-fhir'] + '/fhir/');
	});

	app.constant('config', {
		app: {
			title: 'VA FitHeart',
			pages: ['Home']
		},
        formats: {
            FRONTEND: {
                DATE: 'MM/dd/yyyy',
                TIME: 'hh:mm a',
                DATE_TIME: 'MM/dd/yyyy hh:mm a'
            },
            BACKEND: {
                DATE: 'yyyy-MM-dd',
                TIME: 'HH:mm ss',
                DATE_TIME: 'yyyy-MM-dd HH:mm:ss'
            }
        },
        defaults: {
            DATE_RANGE_DELTA: {days : 30}
        },
	});
});
